/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.dbcp.dbcp.cpdsadapter;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Vector;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;
import javax.sql.StatementEventListener;
import org.apache.tomcat.dbcp.dbcp.DelegatingConnection;
import org.apache.tomcat.dbcp.dbcp.DelegatingPreparedStatement;
import org.apache.tomcat.dbcp.dbcp.PStmtKey;
import org.apache.tomcat.dbcp.dbcp.PoolableCallableStatement;
import org.apache.tomcat.dbcp.dbcp.PoolablePreparedStatement;
import org.apache.tomcat.dbcp.dbcp.PoolingConnection;
import org.apache.tomcat.dbcp.dbcp.cpdsadapter.ConnectionImpl;
import org.apache.tomcat.dbcp.pool.KeyedObjectPool;
import org.apache.tomcat.dbcp.pool.KeyedPoolableObjectFactory;
import org.apache.tomcat.util.compat.JreCompat;

class PooledConnectionImpl
implements PooledConnection,
KeyedPoolableObjectFactory<PStmtKey, DelegatingPreparedStatement> {
    private static final String CLOSED = "Attempted to use PooledConnection after closed() was called.";
    private Connection connection = null;
    private final DelegatingConnection delegatingConnection;
    private Connection logicalConnection = null;
    private final Vector<ConnectionEventListener> eventListeners;
    private final Vector<StatementEventListener> statementEventListeners = new Vector();
    boolean isClosed;
    protected KeyedObjectPool<PStmtKey, DelegatingPreparedStatement> pstmtPool = null;
    private boolean accessToUnderlyingConnectionAllowed = false;

    PooledConnectionImpl(Connection connection, KeyedObjectPool<PStmtKey, DelegatingPreparedStatement> pool) {
        this.connection = connection;
        this.delegatingConnection = connection instanceof DelegatingConnection ? (DelegatingConnection)connection : new DelegatingConnection(connection);
        this.eventListeners = new Vector();
        this.isClosed = false;
        if (pool != null) {
            this.pstmtPool = pool;
            this.pstmtPool.setFactory(this);
        }
    }

    @Override
    public void addConnectionEventListener(ConnectionEventListener listener) {
        if (!this.eventListeners.contains(listener)) {
            this.eventListeners.add(listener);
        }
    }

    @Override
    public void addStatementEventListener(StatementEventListener listener) {
        if (!this.statementEventListeners.contains(listener)) {
            this.statementEventListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        block14: {
            this.assertOpen();
            this.isClosed = true;
            try {
                if (this.pstmtPool == null) break block14;
                try {
                    this.pstmtPool.close();
                }
                finally {
                    this.pstmtPool = null;
                }
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new SQLException("Cannot close connection (return to pool failed)", e);
            }
            finally {
                try {
                    this.connection.close();
                }
                finally {
                    this.connection = null;
                }
            }
        }
    }

    private void assertOpen() throws SQLException {
        if (this.isClosed) {
            throw new SQLException(CLOSED);
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        this.assertOpen();
        if (this.logicalConnection != null && !this.logicalConnection.isClosed()) {
            throw new SQLException("PooledConnection was reused, withoutits previous Connection being closed.");
        }
        this.logicalConnection = new ConnectionImpl(this, this.connection, this.isAccessToUnderlyingConnectionAllowed());
        return this.logicalConnection;
    }

    @Override
    public void removeConnectionEventListener(ConnectionEventListener listener) {
        this.eventListeners.remove(listener);
    }

    @Override
    public void removeStatementEventListener(StatementEventListener listener) {
        this.statementEventListeners.remove(listener);
    }

    protected void finalize() throws Throwable {
        try {
            this.connection.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.logicalConnection != null && !this.logicalConnection.isClosed()) {
            throw new SQLException("PooledConnection was gc'ed, withoutits last Connection being closed.");
        }
    }

    void notifyListeners() {
        ConnectionEvent event = new ConnectionEvent(this);
        Object[] listeners = this.eventListeners.toArray();
        for (int i = 0; i < listeners.length; ++i) {
            ((ConnectionEventListener)listeners[i]).connectionClosed(event);
        }
    }

    PreparedStatement prepareStatement(String sql) throws SQLException {
        if (this.pstmtPool == null) {
            return this.connection.prepareStatement(sql);
        }
        try {
            return this.pstmtPool.borrowObject(this.createKey(sql));
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLException("Borrow prepareStatement from pool failed", e);
        }
    }

    PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        if (this.pstmtPool == null) {
            return this.connection.prepareStatement(sql, resultSetType, resultSetConcurrency);
        }
        try {
            return this.pstmtPool.borrowObject(this.createKey(sql, resultSetType, resultSetConcurrency));
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLException("Borrow prepareStatement from pool failed", e);
        }
    }

    PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        if (this.pstmtPool == null) {
            return this.connection.prepareStatement(sql, autoGeneratedKeys);
        }
        try {
            return this.pstmtPool.borrowObject(this.createKey(sql, autoGeneratedKeys));
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLException("Borrow prepareStatement from pool failed", e);
        }
    }

    PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        if (this.pstmtPool == null) {
            return this.connection.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        try {
            return this.pstmtPool.borrowObject(this.createKey(sql, resultSetType, resultSetConcurrency, resultSetHoldability));
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLException("Borrow prepareStatement from pool failed", e);
        }
    }

    PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        if (this.pstmtPool == null) {
            return this.connection.prepareStatement(sql, columnIndexes);
        }
        try {
            return this.pstmtPool.borrowObject(this.createKey(sql, columnIndexes));
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLException("Borrow prepareStatement from pool failed", e);
        }
    }

    PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        if (this.pstmtPool == null) {
            return this.connection.prepareStatement(sql, columnNames);
        }
        try {
            return this.pstmtPool.borrowObject(this.createKey(sql, columnNames));
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLException("Borrow prepareStatement from pool failed", e);
        }
    }

    protected PStmtKey createKey(String sql, int autoGeneratedKeys) {
        return new PStmtKey(this.normalizeSQL(sql), this.getCatalogOrNull(), this.getSchemaOrNull(), autoGeneratedKeys);
    }

    protected PStmtKey createKey(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
        return new PStmtKey(this.normalizeSQL(sql), this.getCatalogOrNull(), this.getSchemaOrNull(), resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    protected PStmtKey createKey(String sql, int[] columnIndexes) {
        return new PStmtKey(this.normalizeSQL(sql), this.getCatalogOrNull(), this.getSchemaOrNull(), columnIndexes);
    }

    protected PStmtKey createKey(String sql, String[] columnNames) {
        return new PStmtKey(this.normalizeSQL(sql), this.getCatalogOrNull(), this.getSchemaOrNull(), columnNames);
    }

    protected PStmtKey createKey(String sql, int resultSetType, int resultSetConcurrency) {
        return new PStmtKey(this.normalizeSQL(sql), this.getCatalogOrNull(), this.getSchemaOrNull(), resultSetType, resultSetConcurrency);
    }

    protected PStmtKey createKey(String sql) {
        return new PStmtKey(this.normalizeSQL(sql), this.getCatalogOrNull(), this.getSchemaOrNull());
    }

    protected String normalizeSQL(String sql) {
        return sql.trim();
    }

    private String getCatalogOrNull() {
        try {
            return this.connection == null ? null : this.connection.getCatalog();
        }
        catch (SQLException e) {
            return null;
        }
    }

    private String getSchemaOrNull() {
        try {
            return this.connection == null ? null : JreCompat.getInstance().getSchema(this.connection);
        }
        catch (SQLException e) {
            return null;
        }
    }

    @Override
    public DelegatingPreparedStatement makeObject(PStmtKey key) throws Exception {
        if (null == key) {
            throw new IllegalArgumentException();
        }
        if (key.getStmtType() == PoolingConnection.StatementType.PREPARED_STATEMENT) {
            PreparedStatement statement = (PreparedStatement)key.createStatement(this.connection);
            PoolablePreparedStatement<PStmtKey> pps = new PoolablePreparedStatement<PStmtKey>(statement, key, this.pstmtPool, this.delegatingConnection);
            return pps;
        }
        CallableStatement statement = (CallableStatement)key.createStatement(this.connection);
        return new PoolableCallableStatement(statement, key, this.pstmtPool, this.delegatingConnection);
    }

    @Override
    public void destroyObject(PStmtKey key, DelegatingPreparedStatement obj) throws Exception {
        obj.getInnermostDelegate().close();
    }

    @Override
    public boolean validateObject(PStmtKey key, DelegatingPreparedStatement obj) {
        return true;
    }

    @Override
    public void activateObject(PStmtKey key, DelegatingPreparedStatement obj) throws Exception {
        obj.activate();
    }

    @Override
    public void passivateObject(PStmtKey key, DelegatingPreparedStatement obj) throws Exception {
        obj.clearParameters();
        obj.passivate();
    }

    public synchronized boolean isAccessToUnderlyingConnectionAllowed() {
        return this.accessToUnderlyingConnectionAllowed;
    }

    public synchronized void setAccessToUnderlyingConnectionAllowed(boolean allow) {
        this.accessToUnderlyingConnectionAllowed = allow;
    }
}

